/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.plugin.PluginIndexProvider;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class StoragePluginIndexProvider
implements PluginIndexProvider {
    private StorageManager storageManager;

    public StoragePluginIndexProvider(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public List<PluginIndexProvider.PluginReference> references() {
        Path pluginReferencesPath = this.storageManager.getPluginReferencesPath();
        if (!Files.exists(pluginReferencesPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Sonarlint.PluginReferences protoReferences = ProtobufUtil.readFile(pluginReferencesPath, Sonarlint.PluginReferences.parser());
        return Lists.transform(protoReferences.getReferenceList(), new Function<Sonarlint.PluginReferences.PluginReference, PluginIndexProvider.PluginReference>(){

            @Override
            public PluginIndexProvider.PluginReference apply(Sonarlint.PluginReferences.PluginReference input) {
                return new PluginIndexProvider.PluginReference().setHash(input.getHash()).setFilename(input.getFilename());
            }
        });
    }
}

